'Nome       : EncDocCer_Pgm.inc
'Tipo       : INC
'Data       : 2010/12/16
'Versao     : 1.0c
'Descricao  : Inclusao de funcoes para documentos certificados

'==============================================================================
'#VER - Historia de modificacoes
'==============================================================================
'- Versao : 1.0c  ____/__/__ --------------------------------------------------
'Forcar inicializacao da impressora antes de escrever informacao de anulaccao (texto rodado)

'- Versao : 1.0b  2010/11/17 --------------------------------------------------
'Correccao da variavel CerPgmDe1$ para documentos certificados

'- Versao : 1.0a  2010/11/08 --------------------------------------------------
'Funcoes novas:
'  - DocCerLisAnu, listar informacao de anulado (modo grafico)

'- Versao : 1.0   2010/10/31 --------------------------------------------------
'Versao base


'==============================================================================
'INF - Informacaoes
'==============================================================================
'Incluir este ficheiro a seguir a zona PGM
'
'Exemplo:
'Funcoes para certificacao         =[SIG_DOC_DIR.ENC],EncDocCer_Pgm.inc
'
'Ver exemplo em StdFac.imp ou StdFac.ipw


'------------------------------------------------------------------------------
'Exemplo de alteracoes a executar para usar dados de certificacao
'------------------------------------------------------------------------------
'Sub DocCab 'cabecalho do documento
'comandos a incluir
'call DocCerVarPrp                                  'preparar variaveis referentes a certificacao
'
'comandos existentes
'...
'
'- listar nome do documento ---------------------------------------------------
'Funcao actual:                                @DocNome                        #
'Substituir por:                               @vCerDocIde                     #
'
'- listar numero do documento -------------------------------------------------
'Funcao actual:                                NUMERO DOCUMENTO  : @DocRcNum   #
'Substituir por:                               NUMERO DOCUMENTO  : @vCerDocNum #
'
'...
'end sub


'Sub DocFim 'total do documento
'...
'
'- listar assinatura do documento ---------------------------------------------
'Substituir:
'?                                          |==================================
'?   ** PROCESSADO POR COMPUTADOR **        | @TotalAbv1     : @DocTot        #
'?                                          |                                 #
'
'Por:
'?                                          |==================================
'? @vCerPgmDe1                              | @TotalAbv1     : @DocTot        #
'? @vCerPgmDe2                              |                                 #
'?=============================================================================
'print CerPgmDes$                          'certificacao do programa
'
'...
'end sub


'==============================================================================
#PGM - Programa/Funcoes
'==============================================================================
'- +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
'- (13) --->'Comentario
'- (25) --------------->'Comentario
'- (28) ------------------>'Comentario
'- (40) ------------------------------>'Comentario
'- (43) --------------------------------->'Comentario
'- (46) ------------------------------------>'Comentario
'- (49) --------------------------------------->'Comentario
'- (52) ------------------------------------------>'Comentario
'- (55) --------------------------------------------->'Comentario
'- (58) ------------------------------------------------>'Comentario
'- (61) --------------------------------------------------->'Comentario
'- (64) ------------------------------------------------------>'Comentario
'- (67) --------------------------------------------------------->'Comentario
'- (70) ------------------------------------------------------------>'Comentario


'==============================================================================
'#CER - Certificacao
'==============================================================================
Sub DocCerVarPrp 'preparar variaveis referentes a certificacao
CerDocAnu = 0                                               'assume nao anulado
call DocCerVarPrpNao                                        'preparar valores por defeito

CerPgmNum$ = EncDocCer$("PGM")                              'certificacao do programa (numero)
'MsgBox "","PGM",CerPgmNum$

if CerPgmNum$ <> "" then                                    'programa certificado ?
    call DocCerVarPrpUsa                                    'preparar dados da certificacao
end if
end sub


Sub DocCerLisAnu 'listar informacao de anulado
if CerDocAnu = 1 then                                       'documento anulado ?
   CerDocAnuUsa = CerDocAnuAsp                              'activar aspecto a usar
else
   CerDocAnuUsa = 0                                         'anular aspecto a usar
end if


if CerDocAnuUsa = 1 then                                    'aspecto 1 ?
   anuTx$ = "Documento anulado"                             'texto a listar
   anuPx  =  60                                             'posicao X
   anuPy  = 200                                             'posicao Y

   PrWIN AJT_B, 0, 0                                        'activar posicao nase
   PrWIN COR_T, 240, 170, 130                               'cor de texto RGB

   PrWIN FON, 40, 1                                         'activar fonte

   PrWIN TX_N,   -100, -100,"."                             'inicializar impressao
   PrWIN TX_RO, anuPx,anuPy,45,anuTx$                       'registar informacao

   PrWIN COR_T, 0, 0, 0                                     'activar cor de texto RGB
end if


if CerDocAnuUsa = 2 then                                    'aspecto 2 ?
   anuTx$ = "Documento anulado"                             'texto a listar
   anuPx  =  20                                             'posicao X
   anuPy  = 240                                             'posicao Y

   PrWIN AJT_B, 0, 0                                        'activar posicao nase
   PrWIN COR_T, 240, 170, 130                               'cor de texto RGB

   PrWIN FON, 75, 1                                         'activar fonte

   PrWIN TX_RO, anuPx,anuPy,45,anuTx$                       'registar informacao

   PrWIN COR_T, 0, 0, 0                                     'activar cor de texto RGB
end if
end sub


Sub DocCerVarPrpUsa 'preparar variaveis referentes a certificacao - usa certificacao
res$ = EncDocCer$("DOC.PRP", Enc_Mst_Tdoc$, Enc_Mst_Ndoc$)  'preparar dados do documento
'MsgBox "","CER",res$

'Programa/OLISOFT
ideCer$    = "Processado por Programa Certificado Numero "  'identificacao de certificaco (base)
CerPgmDes$ = ideCer$ + CerPgmNum$                           'certificacao do programa (numero+descricao)
CerPgmDe1$ = "Processado por Programa"                      'certificacao do programa (descricao linha 1)
CerPgmDe2$ = "Certificado Numero " + CerPgmNum$             'certificacao do programa (descricao linha 2)

'Documento
CerDocSit$ = EncDocCer$("DOC.SIT")                          'situacao do documento

if cerDocSit$ = "CER" then                                  'documento certificado ?
   CerDocAss$ = EncDocCer$("DOC.ASI")                       'assinatura do documento (4 digitos)
   CerDocAdi$ = ""                                          'informacao adicional

   CerPgmDes$ = cerDocAss$ + "-" + CerPgmDes$               'certificacao do programa (numero+descricao)
   CerPgmDe1$ = cerDocAss$ + "-" + CerPgmDe1$               'certificacao do programa (descricao linha 1)
end if

if cerDocSit$ = "C+A" then                                  'documento certificado e anulado ?
   adi$="(Anulado)"                                         'informacao adicional

   CerDocAnu  = 1                                           'activar situacao de anulado
   CerDocAss$ = EncDocCer$("DOC.ASI")                       'assinatura do documento (4 digitos)
   CerDocAdi$ = ""                                          'informacao adicional

   CerDocIde$ = CerDocIde$ + " " + adi$                     'identificacao do documento
   CerPgmDes$ = cerDocAss$ + "-" + CerPgmDes$               'certificacao do programa (numero+descricao)
   CerPgmDe1$ = cerDocAss$ + "-" + CerPgmDe1$               'certificacao do programa (descricao linha 1)
end if


if cerDocSit$ = "ANL" then                                  'documento anulado ?
   adi$="(Anulado)"                                         'informacao adicional

   CerDocAnu = 1                                            'activar situacao de anulado
   CerDocAss$ = ""                                          'assinatura do documento (4 digitos)
   CerDocAdi$ = ""                                          'informacao adicional

   CerDocIde$ = CerDocIde$ + " " + adi$                     'identificacao do documento
end if


if cerDocSit$ = "CPO" then                                  'documento copia do original ?
   CerDocAss$ = ""                                          'assinatura do documento (4 digitos)
   CerDocAdi$ = "Cpia do documento original"               'informacao adicional

   CerDocIde$ = CerDocIde$                                  'identificacao do documento
end if

if cerDocSit$ = "PEN" then                                  'documento pendente ?
   adi$="(Pendente)"                                        'informacao adicional

   CerDocAss$ = "(Pendente)"                                'assinatura do documento (4 digitos)
   CerDocAdi$ = ""                                          'informacao adicional

   CerDocIde$ = CerDocIde$ + " " + adi$                     'identificacao do documento
end if
end sub


Sub DocCerVarPrpNao 'preparar variaveis referentes a certificacao - nao usa certificacao
'MsgBox "","CER","Nao usa"

'Programa/OLISOFT
ideCer$    = "** PROCESSADO POR COMPUTADOR **"              'identificacao de certificaco (nao usa)
CerPgmDes$ = ideCer$                                        'certificacao do programa (numero+descricao)
CerPgmDe1$ = ideCer$                                        'certificacao do programa (descricao linha 1)
CerPgmDe2$ = ""                                             'certificacao do programa (descricao linha 2)

'Documento
CerDocIde$ = Doc_Ide_Nome$                                  'identificacao do documento
'CerDocIde$ = Doc_Ide_Sdoc$                                 'identificacao do documento

if DocRcNum$ <> "" then
   CerDocNum$ = DocRcNum$
else
   CerDocNum$ = FrmNdo$("", Enc_Mst_Tdoc$, Enc_Mst_Ndoc$)      'numero do documento
end if

CerDocAss$ = ""                                             'assinatura do documento (4 digitos)
CerDocAdi$ = ""                                             'informacao adicional
end sub

##

